// $(baseName)_AppView.cpp
// ------------------------------
//
// Copyright (c) 2000 Symbian Ltd.  All rights reserved.
//

////////////////////////////////////////////////////////////////////////
//
// Source file for the implementation of the
// application view class - C$(baseName)AppView
//
////////////////////////////////////////////////////////////////////////

#include "$(baseName).h"

//
//             Constructor for the view.
//
C$(baseName)AppView::C$(baseName)AppView()
	{
	}


//             Static NewL() function to start the standard two
//             phase construction.
//
C$(baseName)AppView* C$(baseName)AppView::NewL(const TRect& aRect)
	{
	C$(baseName)AppView* self = new(ELeave) C$(baseName)AppView();
	CleanupStack::PushL(self);
	self->ConstructL(aRect);
	CleanupStack::Pop();
	return self;
	}


//
//             Destructor for the view.
//
C$(baseName)AppView::~C$(baseName)AppView()
	{
	delete i$(baseName)Text;
	}


//             Second phase construction.
//
void C$(baseName)AppView::ConstructL(const TRect& aRect)
    {
			   // Fetch the text from the resource file.
	i$(baseName)Text = iEikonEnv->AllocReadResourceL(R_EXAMPLE_TEXT_HELLO);
	           // Control is a window owning control
	CreateWindowL();
	           // Extent of the control. This is
	           // the whole rectangle available to application.
	           // The rectangle is passed to us from the application UI.
	SetRect(aRect);
			   // At this stage, the control is ready to draw so
	           // we tell the UI framework by activating it.
	ActivateL();
	}


//             Drawing the view - in this application,
//             consists of drawing a simple outline rectangle
//             and then drawing the text in the middle.
//             We use the Normal font supplied by the UI.
//
//             In this application, we don't use the redraw
//             region because it's easier to redraw to
//             the whole client area.
//
void C$(baseName)AppView::Draw(const TRect& /*aRect*/) const
	{
               // Window graphics context
	CWindowGc& gc = SystemGc();
	           // Area in which we shall draw
	TRect      drawRect = Rect();
			   // Font used for drawing text
	const CFont*     fontUsed;

	           // Start with a clear screen
	gc.Clear();
			   // Draw an outline rectangle (the default pen
	           // and brush styles ensure this) slightly
	           // smaller than the drawing area.
	drawRect.Shrink(10,10);
	gc.DrawRect(drawRect);
               // Use the title font supplied by the UI
	fontUsed = iEikonEnv->TitleFont();
	gc.UseFont(fontUsed);
			   // Draw the text in the middle of the rectangle.
	TInt   baselineOffset=(drawRect.Height() - fontUsed->HeightInPixels())/2;
	gc.DrawText(*i$(baseName)Text,drawRect,baselineOffset,CGraphicsContext::ECenter, 0);
               // Finished using the font
	gc.DiscardFont();
	}



